/*
 * Die Sourcecodes, die diesem Buch als Beispiele beiliegen, sind
 * Copyright (c) 2006 - Thomas Ekert. Alle Rechte vorbehalten.
 * 
 * Trotz sorgfltiger Kontrolle sind Fehler in Softwareprodukten nie vollstndig auszuschlieen.
 * Die Sourcodes werden in Ihrem Originalzustand ausgeliefert.
 * Ansprche auf Anpassung, Weiterentwicklung, Fehlerbehebung, Support
 * oder sonstige wie auch immer gearteten Leistungen oder Haftung sind ausgeschlossen.
 * Sie drfen kommerziell genutzt, weiterverarbeitet oder weitervertrieben werden.
 * Voraussetzung hierfr ist, dass fr jeden beteiligten Entwickler, jeweils mindestens
 * ein Exemplar dieses Buches in seiner aktuellen Version als gekauftes Exemplar vorliegt.
 */
package djbuch.kapitel_19;
import djbuch.kapitel_06.*;
/**
 * @author Thomas Ekert
 * 
 */
public class DJLogDemo {

	public static void main(String[] args) {
		DJLog.setLogLevel(DJLog.INFO);
		DJLog.setTraceStatus(true);
		for (int i = 0; i<40; i++) {
			DJLog.write(DJLog.INFO, i + " - Message aus Main (INFO)" + DemoTools.getRandomString(50));
		}
		doTest ();
	}

	
	private static void doTest () {
		DJLog.setLogLevel(DJLog.DEBUG);
		DJLog.setTraceStatus(false);
		for (int i = 0; i<10; i++) {
			DJLog.write(randLogLev (), i + " - Hallo, ich bin eine Log Message (ERROR..DEBUG)" + DemoTools.getRandomString(50));
		}
		DJLog.setLogLevel(DJLog.WARN);
		DJLog.setTraceStatus(true);
		for (int i = 0; i<10; i++) {
			DJLog.write(randLogLev (), i + " - Hallo, ich bin eine Log Message (ERROR..WARN)" + DemoTools.getRandomString(20));
		}
		doOtherTest();
	}
	
	private static void doOtherTest () {
		DJLog.setLogLevel(DJLog.DEBUG);
		DJLog.setTraceStatus(true);
		for (int i = 0; i<5; i++) {
			DJLog.write(randLogLev (), i + " - Hallo, ich bin eine Log Message (ERROR..DEBUG)" + DemoTools.getRandomString(20));
		}		
	}

	// Zufllige LogLevel fr Testzwecke
	private static int randLogLev () {
		return DemoTools.getRandomNumber(DJLog.ERROR,DJLog.DEBUG);
	}
}
